package com.ejie.ab04b.control;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.constantes.ConstantesNum;
import com.ejie.ab04b.exception.ErrorField;
import com.ejie.ab04b.exception.ErrorGenericoException;
import com.ejie.ab04b.model.Centroj73;
import com.ejie.ab04b.model.toolbar.Boton;
import com.ejie.ab04b.model.toolbar.Botonera;
import com.ejie.ab04b.service.Centroj73Service;
import com.ejie.ab04b.util.Utilities;
import com.ejie.ab04b.util.ValidadorNifCifNie;
import com.ejie.ab04b.util.seguridad.UtilSeguridad;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;

/**
 * Centroj73Controller generated by UDA, 25-abr-2016 19:06:31.
 * 
 * @author UDA
 */

@Controller()
@RequestMapping(value = "/centroj73")
public class Centroj73Controller {

	private static final Logger LOGGER = LoggerFactory
			.getLogger(Centroj73Controller.class);

	@Autowired()
	private Centroj73Service centroj73Service;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * codemp001 Integer
	 * 
	 * @param codemp001
	 *            the codemp 001 Centroj73 Objeto correspondiente al
	 *            identificador indicado.
	 * @return the centroj 73
	 */
	@RequestMapping(value = "/{codemp001}", method = RequestMethod.GET)
	public @ResponseBody()
	Centroj73 get(@PathVariable() Integer codemp001) {
		Centroj73 centroj73 = new Centroj73();
		centroj73.setCodemp001(codemp001);
		centroj73 = this.centroj73Service.find(centroj73);
		Centroj73Controller.LOGGER
				.info("[GET - findBy_PK] : Obtener Centroj73 por PK");
		return centroj73;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 * 
	 * filterCentroj73 Centroj73 Objeto que contiene los parametros de filtrado
	 * utilizados en la busqueda.
	 * 
	 * @param filterCentroj73
	 *            the filter centroj 73 List<Centroj73> Lista de objetos
	 *            correspondientes a la busqueda realizada.
	 * @return the all
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Centroj73> getAll(@ModelAttribute() Centroj73 filterCentroj73) {
		Centroj73Controller.LOGGER
				.info("[GET - find_ALL] : Obtener Centroj73 por filtro");
		return this.centroj73Service.findAll(filterCentroj73, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 * 
	 * centroj73 Centroj73 Bean que contiene la informacion a modificar.
	 * 
	 * @param centroj73
	 *            the centroj 73 Centroj73 Bean resultante de la modificacion.
	 * @return the centroj 73
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Centroj73 edit(@RequestBody() Centroj73 centroj73) {
		Centroj73 centroj73Aux = this.centroj73Service.update(centroj73);
		Centroj73Controller.LOGGER
				.info("[PUT] : Centroj73 actualizado correctamente");
		return centroj73Aux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 * centroj73 Centroj73 Bean que contiene la informacion con la que se va a
	 * crear el nuevo registro.
	 * 
	 * @param centroj73
	 *            the centroj 73 Centroj73 Bean resultante del proceso de
	 *            creacion.
	 * @return the centroj 73
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Centroj73 add(@RequestBody() Centroj73 centroj73) {
		Centroj73 centroj73Aux = this.centroj73Service.add(centroj73);
		Centroj73Controller.LOGGER
				.info("[POST] : Centroj73 insertado correctamente");
		return centroj73Aux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 * 
	 * codemp001 Integer Identificador del objeto que se desea eliminar.
	 * 
	 * @param codemp001
	 *            the codemp 001 Centroj73 Bean eliminado.
	 * @return the centroj 73
	 */
	@RequestMapping(value = "/{codemp001}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Centroj73 remove(@PathVariable() Integer codemp001) {
		Centroj73 centroj73 = new Centroj73();
		centroj73.setCodemp001(codemp001);
		this.centroj73Service.remove(centroj73);
		Centroj73Controller.LOGGER
				.info("[DELETE] : Centroj73 borrado correctamente");
		return centroj73;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * model Model
	 * 
	 * @param model
	 *            the model String
	 * @return the form edit
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		Centroj73Controller.LOGGER.info("[GET - View] : centroj73");
		return "centroj73";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * filterCentroj73 Centroj73 Bean que contiene los parametros de filtrado a
	 * emplear. jqGridRequestDto Dto que contiene los parametros de
	 * configuracion propios del RUP_TABLE a aplicar en el filtrado.
	 * 
	 * @param filterCentroj73
	 *            the filter centroj 73
	 * @param jqGridRequestDto
	 *            the jq grid request dto JQGridResponseDto<Centroj73> Dto que
	 *            contiene el resultado del filtrado realizado por el componente
	 *            RUP_TABLE.
	 * @return the JQ grid response dto
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody()
	JQGridResponseDto<Centroj73> filter(
			@RequestJsonBody(param = "filter") Centroj73 filterCentroj73,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto) {
		Centroj73Controller.LOGGER.info("[POST - filter] : Obtener Centroj73s");

		if (filterCentroj73 != null && filterCentroj73.getProvincia() != null
				&& filterCentroj73.getProvincia().getCodProvincia() != null) {
			filterCentroj73.setProvc001(Integer.parseInt(filterCentroj73
					.getProvincia().getCodProvincia()));
		}
		if (filterCentroj73 != null && filterCentroj73.getMunicipio() != null
				&& filterCentroj73.getMunicipio().getCodMunicipio() != null) {
			filterCentroj73.setMunic001(filterCentroj73.getMunicipio()
					.getCodMunicipio());
		}
		return this.centroj73Service.filter(filterCentroj73, jqGridRequestDto,
				false);
	}

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * 
	 * model Model locale Locale
	 * 
	 * @param model
	 *            the model
	 * @param locale
	 *            the locale Centro Objeto correspondiente al identificador
	 *            indicado.
	 * @return the string
	 */
	@RequestMapping(value = "/asignacionNuevo", method = RequestMethod.GET)
	public String nuevoCentro(Model model, Locale locale) {
		Centroj73Controller.LOGGER
				.info("[POST - findBy_PK] : Filtro búsqueda Centros J73");

		model.addAttribute("delegaciones", UtilSeguridad.getInstance()
				.obtenerDelegacionesUsuario());

		return "centroAsignacion";
	}

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * cif String esConsulta boolean ccen Integer model Model
	 * 
	 * @param cif
	 *            the cif
	 * @param esConsulta
	 *            the es consulta
	 * @param ccen
	 *            the ccen
	 * @param model
	 *            the model String
	 * @return the form alta centro
	 */
	@RequestMapping(value = "/formNuevoCentroJ73", method = RequestMethod.GET)
	public String getFormAltaCentro(
			@RequestParam(required = false, value = "cif") String cif,
			@RequestParam(required = false, value = "esConsulta") boolean esConsulta,
			@RequestParam(required = false, value = "ccen") Integer ccen,
			Model model) {
		Centroj73Controller.LOGGER.info("[GET - View] : centroj73");

		/* Preparamos la configuración del comportamiento del modo de acceso */

		/*
		 * Preparamos el model del formulario
		 * usuario.setDelegacion(UtilSeguridad.getInstance()
		 * .obtenerDelegacionUsuario());
		 */
		/*
		 * usuario.setTipoRegistroEntrada(UtilSeguridad.getInstance()
		 * .modoRegistroEntrada());
		 * usuario.setTipoRegistroSalida(UtilSeguridad.getInstance()
		 * .modoRegistroSalida());
		 */
		model.addAttribute("delegaciones", UtilSeguridad.getInstance()
				.obtenerDelegacionesUsuario());
		// if (Constantes.DEL_LAKUA.equals(usuario.getDelegacion())) {
		// usuario.setAutoridades(Constantes.COMBO_AUTORIDADES_ORDEN_LAKUA);
		// } else {
		// usuario.setAutoridades(Constantes.COMBO_AUTORIDADES_ORDEN_DELEGACION);
		// }

		// model.addAttribute("usuario", usuario);

		model.addAttribute("comboTipoIdentif",
				Constantes.LISTA_TIPO_IDENTIF_J73);

		Centroj73 centroj73 = new Centroj73();

		if (cif != null) {
			centroj73.setCcif001(cif);
		}

		if (esConsulta) {
			if (ccen != null) {
				centroj73.setCcen001(ccen);
			}
			centroj73 = this.centroj73Service.findConsultaCentro(centroj73);
			model.addAttribute("esConsulta", "S");
		}
		model.addAttribute("centroj73AltaModel", centroj73);

		// Preparo la configuración de las opciones de la barra de botones
		model.addAttribute("centroj73Alta_toolbar",
				this.preparaToolbarCentroJ73Alta());

		return "altacentroj73";
	}

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * cif String esConsulta boolean ccen Integer model Model
	 * 
	 * @param cif
	 *            the cif
	 * @param model
	 *            the model String
	 * @return the form alta centro
	 */
	@RequestMapping(value = "/findEmpresaNuevoCtr", method = RequestMethod.GET)
	public @ResponseBody()
	Centroj73 findEmpresaNuevoCtr(
			@RequestParam(required = false, value = "cif") String cif,
			Model model) {
		Centroj73Controller.LOGGER.info("[GET - View] : centroj73");

		Centroj73 centroj73 = new Centroj73();

		if (cif != null) {
			centroj73.setCcif001(cif);
		}

		centroj73.setNcen001(1);

		centroj73 = this.centroj73Service.findConsultaNuevoCentro(centroj73);
		if (centroj73 == null) {
			throw new ErrorGenericoException("");
		}
		return centroj73;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 * centroj73 Centroj73 Bean que contiene la informacion con la que se va a
	 * crear el nuevo registro.
	 * 
	 * @param centroj73
	 *            the centroj 73 Centroj73 Bean resultante del proceso de
	 *            creacion.
	 * @return the centroj 73
	 */
	@RequestMapping(value = "/addNuevoCentroJ73", method = RequestMethod.POST)
	public @ResponseBody()
	Centroj73 addNuevoCentroJ73(@RequestBody() Centroj73 centroj73) {
		Centroj73 centroj73Aux = new Centroj73();

		String idUser = UtilSeguridad.getInstance().getAuditUserShort();

		// Validate
		List<ErrorField> errores = this.validateAdd(centroj73);
		if (errores != null && !errores.isEmpty()) {
			throw new ErrorGenericoException(errores);
		}

		try {
			centroj73Aux = this.centroj73Service
					.addCentroJ73(centroj73, idUser);
		} catch (Exception e) {
			throw new ErrorGenericoException("");
		}
		Centroj73Controller.LOGGER
				.info("[POST] : Centroj73 insertado correctamente");
		return centroj73Aux;
	}

	/**
	 * Validate add.
	 * 
	 * centroj73 Centroj73
	 * 
	 * @param centroj73
	 *            the centroj 73 List<ErrorField>
	 * @return the list
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity
	private List<ErrorField> validateAdd(Centroj73 centroj73) {
		List<ErrorField> errorFields = new ArrayList<ErrorField>();

		if (centroj73.getTcif001() == null) {
			errorFields.add(new ErrorField("centro.cif", "error.tipocifnif"));
		}
		if (centroj73.getCcif001() == null) {
			errorFields.add(new ErrorField("centro.cif",
					"validacion.obligatorio"));

		} else if (centroj73.getCcif001() != null
				&& centroj73.getTcif001().equals(Constantes.TIPO_CIF_J73)
				&& !ValidadorNifCifNie.isCifValido(centroj73.getCcif001())) {
			errorFields
					.add(new ErrorField("centro.cif", "error.cif.incorrecto"));
		} else if (centroj73.getCcif001() != null
				&& centroj73.getTcif001().equals(Constantes.TIPO_NIF_J73)
				&& !ValidadorNifCifNie.isNifValido(centroj73.getCcif001())) {
			errorFields
					.add(new ErrorField("centro.cif", "error.nif.incorrecto"));
		} else if (centroj73.getCcif001() != null
				&& centroj73.getTcif001().equals(Constantes.TIPO_NIE_J73)
				&& !ValidadorNifCifNie.isNifValido(centroj73.getCcif001())) {
			errorFields
					.add(new ErrorField("centro.cif", "error.nie.incorrecto"));
		}

		if (centroj73.getRsoc001() == null) {
			errorFields.add(new ErrorField("centro.nombrerazonsocial",
					"validacion.obligatorio"));
		}
		if (centroj73.getCposc001() == null) {
			errorFields.add(new ErrorField("centro.cp",
					"validacion.obligatorio"));
		} else if (centroj73.getCposc001().length() < ConstantesNum.NUM_5) {
			errorFields.add(new ErrorField("centro.cp", "error.cp.corto"));
		}
		if (centroj73.getCodMunic001Str() == null) {
			errorFields.add(new ErrorField("centro.municipio",
					"validacion.obligatorio"));
		}
		if (centroj73.getProvc001() == null) {
			errorFields.add(new ErrorField("centro.provincia",
					"validacion.obligatorio"));
		} else if (centroj73.getProvc001() != null
				&& centroj73.getCposc001() != null
				&& centroj73.getCposc001().length() == ConstantesNum.NUM_5) {
			String strProvCP = centroj73.getCposc001().substring(0,
					ConstantesNum.NUM_2);

			if (Integer.parseInt(strProvCP) != centroj73.getProvc001()) {
				errorFields.add(new ErrorField("centro.cp",
						"error.cp.territorio"));
			}
		}
		if (centroj73.getCodmunif001() == null) {
			errorFields.add(new ErrorField("centro.municipiof",
					"validacion.obligatorio"));
		}
		if (centroj73.getCposf001() == null) {
			errorFields.add(new ErrorField("centro.cpf",
					"validacion.obligatorio"));
		} else if (centroj73.getCposf001().length() < ConstantesNum.NUM_5) {
			errorFields.add(new ErrorField("centro.cpf", "error.cp.corto"));
		}

		if (centroj73.getCodprof001() == null) {
			errorFields.add(new ErrorField("centro.provinciaf",
					"validacion.obligatorio"));
		} else if (centroj73.getCodprof001() != null
				&& centroj73.getCposf001() != null
				&& centroj73.getCposf001().length() == ConstantesNum.NUM_5) {
			String strProvCP = centroj73.getCposf001().substring(0,
					ConstantesNum.NUM_2);

			if (Integer.parseInt(strProvCP) != centroj73.getCodprof001()) {
				errorFields.add(new ErrorField("centro.cpf",
						"error.cpf.territoriof"));
			}
		}
		if (centroj73.getCnae001() == null) {
			errorFields.add(new ErrorField("centro.cnae",
					"validacion.obligatorio"));
		}
		if (centroj73.getSecc001() == null) {
			errorFields.add(new ErrorField("centro.sector",
					"validacion.obligatorio"));
		}
		if (Utilities.getInstance().isEmpty(centroj73.getRegi001())) {
			errorFields.add(new ErrorField("centro.regjur",
					"validacion.obligatorio"));
		}

		return errorFields;
	}

	/**
	 * Prepara los botones de anterior/guardar/siguiente para el combo de meses.
	 * 
	 * String
	 * 
	 * @return the string
	 */
	private String preparaToolbarCentroJ73Alta() {

		ObjectMapper mapper = new ObjectMapper();
		Botonera botonera = new Botonera();
		botonera.addBoton(new Boton("guardar", "guardar"));
		try {
			return mapper.writeValueAsString(botonera);
		} catch (Exception e) {
			return "";
		}
	}
}
